//texture tex0 < string name = "sdf"; >;	// Base texture

//float4x4 WorldViewProjectionMatrix; 

float4x4 WorldMatrix; 
float4x4 ViewMatrix; 
float4x4 ProjectionMatrix; 
float4x4 RotationMatrix;

float4	 FlagCoords;
float	 AnimationState;

sampler BaseTexture  =
sampler_state
{
##	Texture = <tex0>;
	MinFilter = Nearest;
	MagFilter = Nearest;
	WrapS = Repeat;
	WrapT = Repeat;
};

struct VS_INPUT
{
    float4 vPosition  : POSITION;
    float3 vNormal    : NORMAL;
    float2 vTexCoord  : TEXCOORD0;
    float4 vDiffuse   : COLOR;
};

struct VS_OUTPUT
{
    float4  vPosition : POSITION;
    float2  vTexCoord0 : TEXCOORD0;
    float4  vDiffuse   : COLOR;
};


VS_OUTPUT VertexShader_(const VS_INPUT v )
{
	VS_OUTPUT Out = (VS_OUTPUT)0;
	//float4x4 WorldView = mul(RotationMatrix,WorldMatrix );
	float4x4 WorldView = mul(WorldMatrix, ViewMatrix);
	float4 InPosition = v.vPosition;
	
	// 3.14159265f*2.0f;
	float vThisY = 1.5f * v.vDiffuse.b * sin( -AnimationState + v.vDiffuse.b*3.14159265*2.0f*1.0f );
	
	float3 v0 = float3( 0, vThisY, 0 );
	
	//InPosition.y += 0.5f + vThisY*0.3f;
	InPosition.z += vThisY*0.3f;

	float3 P = mul(InPosition, (float4x3)WorldView);
	Out.vPosition  = mul(float4(P, 1), ProjectionMatrix);

	Out.vTexCoord0.x = v.vTexCoord.x/FlagCoords.x;
	Out.vTexCoord0.x = Out.vTexCoord0.x + FlagCoords.z;
	Out.vTexCoord0.y = v.vTexCoord.y/FlagCoords.y;
	Out.vTexCoord0.y = Out.vTexCoord0.y + FlagCoords.w;

	//Out.vDiffuse.r = sin( -AnimationState + (v.vDiffuse.b + 1.0f/200.0f)*3.14159265*2.0f*1.0f ) * 0.2 + 0.6;
	Out.vDiffuse.r = sin( -AnimationState + v.vDiffuse.b*3.14159265*2.0f*1.0f ) * 0.2 + 0.6;

	return Out;
}


float4 PixelShader_( VS_OUTPUT v ) : COLOR
{
	float4 OutColor = tex2D( BaseTexture, v.vTexCoord0.xy );
	OutColor.rgb *= v.vDiffuse.rrr;
	
	return OutColor;
}


technique tec0
{
	pass p0
	{
//TODO		fvf = XYZ | Normal | Diffuse | Tex1;

		LightEnable[0] = false;
		LightingEnable = false;

		BlendEnable = true;

//TODO		Texture[0] = <tex0>;

//TODO		ColorOp[0] = Modulate;
//TODO		ColorArg1[0] = Texture;
//TODO		ColorArg2[0] = current;
  
//TODO		ColorOp[1] = Disable;
//TODO		AlphaOp[1] = Disable;

		VertexProgram = compile arbvp1 VertexShader_();
		FragmentProgram = compile arbfp1 PixelShader_();
	}
}
